"use client"
import { FadeIn } from "@/components/animations/fade-in";
import LoadingCircle from "@/components/icons/loading.circle";
import { Card, CardContent, CardHeader, CardTitle } from "@/components/ui/card";
import { DEFAULT_SWR_OPTIONS } from "@/config/swr";
import BarChart from "@/features/engagement/components/BarChart";
import { ExclamationTriangleIcon } from "@radix-ui/react-icons";
import useSWR from "swr";
import { fetchDailySiteVisits, fetchMonthlySessionTime, fetchMonthlySiteVisits, fetchYearlySessionTime } from "../lib/actions.server";
import { ChartCard } from "./ChartCard";
import Info from "./Info";

export default function SiteAnalytics() {
  const { data, isLoading } = useSWR(
    ["SITE_ANALYTICS"],
    () => Promise.all([
      fetchMonthlySiteVisits(12),
      fetchDailySiteVisits(30),
      fetchMonthlySessionTime(),
      fetchYearlySessionTime(),
    ]),
    DEFAULT_SWR_OPTIONS
  )

  if (isLoading || !data) {
    return (
      <INTERNAL__ErrorState isLoading={isLoading} data={data} />
    )
  }

  const [
    monthlyVisits,
    dailyVisits,
    monthlySessionTime,
    yearlySessionTime,
  ] = data

  return (
    <div className="grid auto-rows-min gap-3 md:grid-cols-3">
      <FadeIn className="rounded-xl bg-muted/50 flex-1 " delay={0.1}>
        <ChartCard title="Site Visits Last 30 Days">
          <BarChart data={dailyVisits} />
        </ChartCard>
      </FadeIn>
      <FadeIn className="rounded-xl bg-muted/50 flex-1 " delay={0.2}>
        <ChartCard title="Site Visits Last 12 Months">
          <BarChart data={monthlyVisits} />
        </ChartCard>
      </FadeIn>
      <FadeIn className="rounded-xl bg-muted/50 flex-1 flex flex-col" delay={0.3}>
        <Card className="h-full">
          <CardHeader>
            <CardTitle>
              Average User Session Time
              <Info />
            </CardTitle>
          </CardHeader>
          <CardContent>
            <div className="flex flex-col h-full gap-6">
              <div className="items-center flex flex-col">
                <div className="grid grid-rows-1 text-primary text-7xl font-bold p-2 pb-0">
                  <div className="grid grid-cols-[auto_auto_auto_auto] gap-1">
                    <div className="text-right">{monthlySessionTime.minutes ?? '00'}</div>
                    <span className="text-left text-3xl flex flex-col justify-end pb-1 mr-1">m</span>
                    <div className="text-right">{monthlySessionTime.seconds ?? '00'}</div>
                    <div className="text-left text-3xl flex flex-col justify-end pb-1">s</div>
                  </div>
                </div>
                <div className="text-sm text-gray-500">Last 30 Days</div>
              </div>
              <div className="items-center flex flex-col">
                <div className="grid grid-rows-1 text-primary text-7xl font-bold p-2 pb-0">
                  <div className="grid grid-cols-[auto_auto_auto_auto] gap-1">
                    <div className="text-right">{yearlySessionTime.minutes ?? '00'}</div>
                    <div className="text-left text-3xl flex flex-col justify-end pb-1 mr-1">m</div>
                    <div className="text-right">{yearlySessionTime.seconds ?? '00'}</div>
                    <div className="text-left text-3xl flex flex-col justify-end pb-1">s</div>
                  </div>
                </div>
                <div className="text-sm text-gray-500">Last 12 Months</div>
              </div>
            </div>
          </CardContent>
        </Card>
      </FadeIn>
    </div>
  );
}

function INTERNAL__ErrorState<TData>({
  isLoading,
}: {
  isLoading: boolean,
  data: TData
}) {
  return (
    <div className="grid auto-rows-min gap-3 md:grid-cols-3">
      <FadeIn className="rounded-xl bg-muted/50 flex-1 " delay={0.1}>
        <ChartCard title="Site Visits Last 30 Days">
          <div className="grid place-items-center h-full">
            {isLoading ? (
              <LoadingCircle className="size-3" />
            ) : (
              <ExclamationTriangleIcon className="size-3 text-destructive" />
            )}
          </div>
        </ChartCard>
      </FadeIn>
      <FadeIn className="rounded-xl bg-muted/50 flex-1 " delay={0.2}>
        <ChartCard title="Site Visits Last 12 Months">
          <div className="grid place-items-center h-full">
            {isLoading ? (
              <LoadingCircle className="size-3" />
            ) : (
              <ExclamationTriangleIcon className="size-3 text-destructive" />
            )}
          </div>
        </ChartCard>
      </FadeIn>
      <FadeIn className="rounded-xl bg-muted/50 flex-1" delay={0.3}>
        <ChartCard title="Average Engagement Time">
          <div className="grid place-items-center h-full">
            {isLoading ? (
              <LoadingCircle className="size-3" />
            ) : (
              <ExclamationTriangleIcon className="size-3 text-destructive" />
            )}
          </div>
        </ChartCard>
      </FadeIn>
    </div>
  )
}
